<?php
require_once "../Api.php";
require "./get/getConnectionMaser.php";
require "./put/updateConnectionMaser.php";
require "./post/createConnectionMaser.php";
require "./patch/changeConnectionMaser.php";
require "./delete/deleteConnectionMaser.php";

class connectionMaserApi extends Api
{
   public $apiName = "connection_master";

   /**
    * Метод GET
    * Вывод списка всех записей
    * http://ДОМЕН/ConnectionMaser
    * @return string
    */
   public function getAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "search":
               return searchAvalibleCams($id);
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод POST
    * Создание новой записи
    * http://ДОМЕН/ConnectionMaser
    * @return string
    */
   public function createAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "setup":
               return setupAvalibleCamera();
               break;
            case "setups":
               return setupAvalibleCameras();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PATCH
    * Создание новой записи
    * http://ДОМЕН/ConnectionMaser
    * @return string
    */
   public function changeAction()
   {
      $path = getParams();
      if (isset($path)) {
         $key = $path[0];
         $id = count($path) == 2 ? (int) $path[1] : null;
         switch ($key) {
            case "camera":
               changeCameraSettings();
               break;
            case "conflicts":
               fixConflicts();
               break;
            default:
               break;
         }
      } else {
         header("HTTP/1.1 400 Bad Request");
         die();
      }
   }

   /**
    * Метод PUT
    * Обновление отдельной записи (по ее id)
    * http://ДОМЕН/ConnectionMaser
    * @return string
    */
   public function updateAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    newConnection($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }

   /**
    * Метод DELETE
    * Удаление отдельной записи (по ее id)
    * http://ДОМЕН/ConnectionMaser
    * @return string
    */
   public function deleteAction()
   {
      /*  $path = getParams();
        if (isset($path)) {
            $key = $path[0];
            $id = count($path) == 2 ? $path[1] : null;
            switch ($key) {
                case 'channels':
                    resetCamera($id);
                    break;
                default:
                    break;
            }
        } else {
            header('HTTP/1.1 400 Bad Request');
            die();
        } */
   }
}
